# coding: utf-8
import pandas as pd
import numpy as np
from joblib import load, dump
from src.Linear_Bandits import linear_bandits
import os

####################################################################################
####################################################################################
############################# AREA OF INPUT PARAMETERS#############################
####################################################################################
####################################################################################

##### Environment Parameters
PATH = "." # Root directory, should be the same path this "README.md" file locates
PATH_DATA = f"{PATH}/data" # Path for data
PATH_MODELS = f"{PATH}/models" # Path for models

##### Parameters for Bandits
size_norm = 50000 # T, use 50000 to reproduce the results
budget = 1600 # Budget constraint, to reproduce, test with 1600 and 2200
random_seed = 1989 # To reproduce the results, run 3 times with 1989, 1990, and 1991

####################################################################################
####################################################################################
############# Create Output Path, Load the data and Conversion Model ###############
####################################################################################
####################################################################################
### Load Data and Model
dt_raw = pd.read_parquet(f"{PATH_DATA}/dt_env.parq")
model_conversion = load(f"{PATH_MODELS}/conversion_model.pkl")

dict_hyper = load(f"{PATH_MODELS}/budget_{budget}/dict_hyper.pkl")
print(dict_hyper)

lmd_logistic = dict_hyper["lmd_logistic"]
lmd_linear = dict_hyper["lmd_linear"]
Z_linear = dict_hyper["Z_linear"]

##### Create the folder for the output model
if os.path.isdir(f"{PATH_MODELS}/budget_{budget}"):
    pass
else:
    os.makedirs(f"{PATH_MODELS}/budget_{budget}")

if os.path.isdir(f"{PATH_MODELS}/budget_{budget}/tuning_random_seed_{random_seed}"):
    pass
else:
    os.makedirs(f"{PATH_MODELS}/budget_{budget}/tuning_random_seed_{random_seed}")

####################################################################################
####################################################################################
############################# Prepare the data #####################################
####################################################################################
####################################################################################

##### Parameters of General Bandits
var_model = ["RISK_SCORE", "EDUCATION", "MARRIAGE", "AMOUNT_CLUSTER", "AGE_CLUSTER"]
var_model_onehot = list(model_conversion.feature_names_in_)
var_base_reward_costs = ["amount_norm", "discount_base_norm", "discount", "constant"]
list_actions = [-1] + [10, 20, 35, 55, 80]

##### Prepare the data
dt_raw["discount"] = 0
dt_raw["constant"] = 1
np.random.seed(random_seed)
dt_env = dt_raw.sample(size_norm, replace=True).reset_index(drop = True)

####################################################################################
####################################################################################
######### Run Linear Bandits with different hyperparameters and Export Model #######
####################################################################################
####################################################################################

for eta_oco_ in [0.005, 0.01, 0.05, 0.1, 0.2]:
    eta_oco_str_  = "0" + str(eta_oco_)[2:]
    for UCB_multiply_ in [0.025, 0.1, 0.3]:

        UCB_multiply_str_  = "0" + str(UCB_multiply_)[2:]
        print(UCB_multiply_str_)
        
        dict_linear_bandits_ = \
            {"var_rate":"interest_rate", "var_context":var_model, "var_model_onehot":var_model_onehot,
             "var_base_reward_costs":var_base_reward_costs, "eta_oco":eta_oco_, "seed":random_seed ,
             "list_actions":list_actions, "model_conversion":model_conversion, "Z":Z_linear, "norm_costs1":7,
             "T":size_norm, "budget":budget, "lmd":lmd_linear, "verbose":True,
             "UCB_multiply":UCB_multiply_, "n_random_action":50}

        obj_linear_bandits_ = linear_bandits(dict_linear_bandits_, dt_env)
        obj_linear_bandits_.run_simulation()

        dump(obj_linear_bandits_,
             f"{PATH_MODELS}/budget_{budget}/tuning_random_seed_{random_seed}/linear_bandits_eta{eta_oco_str_}_C{UCB_multiply_str_}.pkl")

        print("------------------------------")

